/*
 * Decompiled with CFR 0.152.
 */
package exploit.conversion;

import exploit.conversion.Converter;
import exploit.conversion.MorphLink;
import exploit.conversion.MorphLinkList;
import exploit.conversion.MorphShape;
import exploit.conversion.RBase;
import exploit.conversion.RCurve;
import exploit.conversion.REdge;
import exploit.conversion.RGraph;
import exploit.conversion.RNode;
import flash.objects.FEdge;
import flash.objects.FFill;
import flash.objects.FMorph;
import flash.objects.FMorphLine;
import flash.objects.FMovie;
import flash.objects.FStyle;
import flash.objects.FStyleChange;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.Vector;

public class MorphConverter
implements Converter {
    private int myTotal = 0;
    private int myValue = 0;
    private int myObjectTotal = 0;
    private int myObjectValue = 0;
    private boolean finished = false;
    private boolean cancel = false;
    private static final String[] myStatusMessages = new String[]{"Processing Shape", "Sorting Edges", "Building Graphs"};
    private int myStatus = 0;

    @Override
    public String getName() {
        return "Morph Conversion Engine";
    }

    @Override
    public String getStatus() {
        return myStatusMessages[this.myStatus];
    }

    @Override
    public void cancel() {
        this.cancel = true;
    }

    @Override
    public int getObjectCount() {
        return this.myObjectTotal;
    }

    @Override
    public int getCurrentObject() {
        return this.myObjectValue;
    }

    @Override
    public int getValue() {
        return this.myValue;
    }

    @Override
    public int getTotal() {
        return this.myTotal;
    }

    @Override
    public boolean finished() {
        return this.finished;
    }

    @Override
    public void update(FMovie fMovie) {
        Vector vector = fMovie.getObjectVector();
        this.myObjectTotal = vector.size();
        for (int i = 0; i < vector.size() && !this.cancel; ++i) {
            this.myObjectValue = i;
            Object e = vector.get(i);
            if (!(e instanceof FMorph)) continue;
            FMorph fMorph = (FMorph)e;
            Vector vector2 = new Vector();
            Vector vector3 = new Vector();
            Vector<RBase> vector4 = new Vector<RBase>();
            Vector vector5 = new Vector();
            Vector vector6 = new Vector();
            Vector vector7 = new Vector();
            this.update(fMorph.getStartStyle(), vector2, vector6, vector7, true);
            this.update(fMorph.getEndStyle(), vector3, vector6, vector7, true);
            for (int j = 0; j < vector2.size(); ++j) {
                Vector vector8 = (Vector)vector2.get(j);
                Vector vector9 = (Vector)vector3.get(j);
                for (int k = 0; k < vector8.size(); ++k) {
                    RBase rBase = (RBase)vector8.get(k);
                    rBase.setSecondEdge((RBase)vector9.get(0));
                    vector4.add(rBase);
                }
            }
            this.sortPaths(vector6, vector7, vector4, vector5);
            fMorph.setRenderData(vector5);
            fMorph.clean();
        }
        this.finished = true;
        if (!this.cancel) {
            fMovie.setReady(true);
        } else {
            fMovie.setReady(false);
        }
    }

    public void update(FStyle fStyle, Vector vector, Vector vector2, Vector vector3, boolean bl) {
        int n;
        Vector vector4 = fStyle.getFillStyles();
        Vector vector5 = fStyle.getLineStyles();
        FFill fFill = null;
        FFill fFill2 = null;
        FMorphLine fMorphLine = null;
        for (n = 0; n < vector4.size(); ++n) {
            vector2.add(vector4.get(n));
        }
        for (n = 0; n < vector5.size(); ++n) {
            vector3.add(vector5.get(n));
        }
        Vector vector6 = fStyle.getShapeRecords();
        int n2 = 0;
        long l = 0L;
        long l2 = 0L;
        for (int i = 0; i < vector6.size(); ++i) {
            Object object;
            Object e = vector6.get(i);
            if (e instanceof FStyleChange) {
                int n3;
                object = (FStyleChange)e;
                if (((FStyleChange)object).isMoveTo()) {
                    l = ((FStyleChange)object).getMoveDeltaX();
                    l2 = ((FStyleChange)object).getMoveDeltaY();
                }
                if (((FStyleChange)object).isFillStyle1()) {
                    n3 = ((FStyleChange)object).getFillStyle1();
                    fFill = n3 == 0 ? null : (FFill)vector4.get(n3 - 1);
                }
                if (((FStyleChange)object).isFillStyle0()) {
                    n3 = ((FStyleChange)object).getFillStyle0();
                    fFill2 = n3 == 0 ? null : (FFill)vector4.get(n3 - 1);
                }
                if (((FStyleChange)object).isLineStyle()) {
                    n3 = ((FStyleChange)object).getLineStyle();
                    fMorphLine = n3 == 0 ? null : (FMorphLine)vector5.get(n3 - 1);
                }
                if (!((FStyleChange)object).isNewStyles()) continue;
                vector4 = ((FStyleChange)object).getFillStyleArray();
                vector5 = ((FStyleChange)object).getLineStyleArray();
                for (n3 = 0; n3 < vector4.size(); ++n3) {
                    vector2.add(vector4.get(n3));
                }
                for (n3 = 0; n3 < vector5.size(); ++n3) {
                    vector3.add(vector5.get(n3));
                }
                continue;
            }
            if (!(e instanceof FEdge)) continue;
            object = (FEdge)e;
            long l3 = 0L;
            long l4 = 0L;
            if (bl) {
                RBase rBase;
                Vector<RBase> vector7 = new Vector<RBase>();
                if (((FEdge)object).getStyle() == 1) {
                    if (fFill != null && fFill == fFill2) {
                        rBase = new REdge(null, null, l, l2, ((FEdge)object).getDeltaX(), ((FEdge)object).getDeltaY());
                        l3 = ((REdge)rBase).getEndX();
                        l4 = ((REdge)rBase).getEndY();
                    } else {
                        if (fFill != null) {
                            rBase = new REdge(fFill, null, l, l2, ((FEdge)object).getDeltaX(), ((FEdge)object).getDeltaY());
                            rBase.setID(((FEdge)object).getID());
                            l3 = ((REdge)rBase).getEndX();
                            l4 = ((REdge)rBase).getEndY();
                            vector7.add(rBase);
                        }
                        if (fFill2 != null) {
                            rBase = new REdge(fFill2, null, l, l2, ((FEdge)object).getDeltaX(), ((FEdge)object).getDeltaY());
                            ((REdge)rBase).flip();
                            rBase.setID(((FEdge)object).getID());
                            l3 = ((REdge)rBase).getStartX();
                            l4 = ((REdge)rBase).getStartY();
                            vector7.add(rBase);
                        }
                    }
                    if (fMorphLine != null || fMorphLine == null && fFill2 == null && fFill == null) {
                        rBase = new REdge(null, fMorphLine, l, l2, ((FEdge)object).getDeltaX(), ((FEdge)object).getDeltaY());
                        rBase.setID(((FEdge)object).getID());
                        l3 = ((REdge)rBase).getEndX();
                        l4 = ((REdge)rBase).getEndY();
                        vector7.add(rBase);
                    }
                    l = l3;
                    l2 = l4;
                } else if (((FEdge)object).getStyle() == 0) {
                    if (fFill != null && fFill == fFill2) {
                        rBase = new RCurve(null, null, l, l2, ((FEdge)object).getAnchorDeltaX(), ((FEdge)object).getAnchorDeltaY(), ((FEdge)object).getControlDeltaX(), ((FEdge)object).getControlDeltaY());
                        l3 = ((RCurve)rBase).getEndX();
                        l4 = ((RCurve)rBase).getEndY();
                    } else {
                        if (fFill != null) {
                            rBase = new RCurve(fFill, null, l, l2, ((FEdge)object).getAnchorDeltaX(), ((FEdge)object).getAnchorDeltaY(), ((FEdge)object).getControlDeltaX(), ((FEdge)object).getControlDeltaY());
                            rBase.setID(((FEdge)object).getID());
                            l3 = ((RCurve)rBase).getEndX();
                            l4 = ((RCurve)rBase).getEndY();
                            vector7.add(rBase);
                        }
                        if (fFill2 != null) {
                            rBase = new RCurve(fFill2, null, l, l2, ((FEdge)object).getAnchorDeltaX(), ((FEdge)object).getAnchorDeltaY(), ((FEdge)object).getControlDeltaX(), ((FEdge)object).getControlDeltaY());
                            ((RCurve)rBase).flip();
                            rBase.setID(((FEdge)object).getID());
                            l3 = ((RCurve)rBase).getStartX();
                            l4 = ((RCurve)rBase).getStartY();
                            vector7.add(rBase);
                        }
                    }
                    if (fMorphLine != null || fMorphLine == null && fFill2 == null && fFill == null) {
                        rBase = new RCurve(null, fMorphLine, l, l2, ((FEdge)object).getAnchorDeltaX(), ((FEdge)object).getAnchorDeltaY(), ((FEdge)object).getControlDeltaX(), ((FEdge)object).getControlDeltaY());
                        rBase.setID(((FEdge)object).getID());
                        l3 = ((RCurve)rBase).getEndX();
                        l4 = ((RCurve)rBase).getEndY();
                        vector7.add(rBase);
                    }
                    l = l3;
                    l2 = l4;
                }
                vector.add(vector7);
            }
            ++n2;
        }
    }

    public void sortPaths(Vector vector, Vector vector2, Vector vector3, Vector vector4) {
        RNode rNode;
        int n;
        this.myStatus = 1;
        RGraph[] rGraphArray = new RGraph[vector.size() + vector2.size() + 1];
        for (n = 0; n < vector.size() + vector2.size() + 1; ++n) {
            rGraphArray[n] = new RGraph(false);
        }
        this.myValue = 0;
        this.myTotal = vector3.size();
        for (n = 0; n < vector3.size(); ++n) {
            this.myValue = n;
            if (this.cancel) {
                return;
            }
            RBase rBase = (RBase)vector3.get(n);
            if (rBase.getFill() != null) {
                rNode = rGraphArray[vector.indexOf(rBase.getFill())].addToNodeLibrary(rBase, n);
                vector3.setElementAt(rNode, n);
                continue;
            }
            if (rBase.getLine() != null) {
                rNode = rGraphArray[vector.size() + vector2.indexOf(rBase.getLine())].addToNodeLibrary(rBase, n);
                vector3.setElementAt(rNode, n);
                continue;
            }
            rNode = rGraphArray[vector.size() + vector2.size()].addToNodeLibrary(rBase, n);
            vector3.setElementAt(rNode, n);
        }
        this.myStatus = 2;
        this.myValue = 0;
        this.myTotal = rGraphArray.length;
        for (n = 0; n < rGraphArray.length; ++n) {
            this.myValue = n;
            rGraphArray[n].setID(n);
            rGraphArray[n].buildConnections();
        }
        MorphLinkList morphLinkList = new MorphLinkList();
        this.myStatus = 1;
        this.myValue = 0;
        this.myTotal = vector3.size();
        for (int i = 0; i < vector3.size(); ++i) {
            int n2;
            MorphShape morphShape;
            rNode = (RNode)vector3.get(i);
            this.myValue = i;
            this.myStatus = 1;
            if (this.cancel) {
                return;
            }
            if (!rNode.isAlive()) continue;
            RGraph rGraph = rNode.getGraph();
            RNode rNode2 = null;
            int n3 = rGraph.getID();
            if (n3 < vector.size() || n3 == vector.size() + vector2.size()) {
                rNode2 = rGraph.findUseableFillPath(rNode);
                if (rNode2 == null) continue;
                morphShape = this.convertFill(rNode2, vector4);
                n2 = rGraph.removeChain(rNode2, true);
                morphShape.fill = rNode2.getObject().getFill();
                morphShape.line = null;
                morphShape.layer = n2;
                MorphShape morphShape2 = null;
                boolean bl = false;
                MorphLink morphLink = morphLinkList.getRoot();
                while (morphLink != null) {
                    MorphShape morphShape3 = morphLink.path;
                    if (morphShape3.line == null && morphShape3.fill == rNode2.getObject().getFill() && (morphShape.myPath.contains(morphShape3.myPath.getCurrentPoint()) || morphShape3.myPath.contains(morphShape.myPath.getCurrentPoint()))) {
                        if (morphShape2 == null) {
                            MorphShape.append(morphShape3, morphShape);
                            morphShape2 = morphShape3;
                        } else {
                            MorphShape.append(morphShape2, morphShape3);
                            MorphLink morphLink2 = morphLink.next;
                            morphLinkList.remove(morphLink);
                            morphLink = morphLink2;
                            bl = true;
                        }
                    }
                    if (morphShape2 == null && morphShape3.layer > n2) {
                        morphLinkList.addBefore(morphLink, morphShape);
                        morphShape = null;
                        morphLink = null;
                    }
                    if (bl) {
                        bl = false;
                        continue;
                    }
                    if (morphLink == null) continue;
                    morphLink = morphLink.next;
                }
                if (morphShape2 != null || morphShape == null) continue;
                morphLinkList.add(morphShape);
                continue;
            }
            rNode2 = rGraph.findUseableLinePath(rNode);
            if (rNode2 == null) continue;
            morphShape = MorphConverter.convertLine(rNode2, vector4);
            n2 = rGraph.removeChain(rNode2, false);
            morphShape.fill = null;
            morphShape.line = rNode2.getObject().getLine();
            morphShape.layer = n2;
            if (morphShape == null) continue;
            morphLinkList.add(morphShape);
        }
        this.myValue = 0;
        this.myTotal = 0;
        MorphLink morphLink = morphLinkList.getRoot();
        while (morphLink != null) {
            vector4.add(morphLink.path);
            morphLink = morphLink.next;
        }
    }

    public static MorphShape convertLine(RNode rNode, Vector vector) {
        RNode rNode2 = rNode;
        RGraph rGraph = rNode.getGraph();
        if (rNode != null) {
            MorphShape morphShape = new MorphShape();
            boolean bl = false;
            while (rNode2 != null) {
                morphShape.addEdge(rNode2.getObject());
                GeneralPath generalPath = rNode2.getObject().getPath();
                if (!bl) {
                    morphShape.myPath = (GeneralPath)generalPath.clone();
                    bl = true;
                } else {
                    PathIterator pathIterator = generalPath.getPathIterator(null);
                    float[] fArray = new float[6];
                    pathIterator.next();
                    while (!pathIterator.isDone()) {
                        switch (pathIterator.currentSegment(fArray)) {
                            case 4: {
                                morphShape.myPath.closePath();
                                break;
                            }
                            case 2: {
                                morphShape.myPath.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                                break;
                            }
                            case 1: {
                                morphShape.myPath.lineTo(fArray[0], fArray[1]);
                                break;
                            }
                            case 0: {
                                morphShape.myPath.moveTo(fArray[0], fArray[1]);
                            }
                        }
                        pathIterator.next();
                    }
                }
                rNode2 = rNode2.child;
            }
            return morphShape;
        }
        return null;
    }

    public MorphShape convertFill(RNode rNode, Vector vector) {
        RNode rNode2 = rNode;
        RGraph rGraph = rNode.getGraph();
        if (rNode != null) {
            MorphShape morphShape = new MorphShape();
            boolean bl = false;
            while (rNode2 != null) {
                morphShape.addEdge(rNode2.getObject());
                GeneralPath generalPath = rNode2.getObject().getPath();
                if (!bl) {
                    morphShape.myPath = (GeneralPath)generalPath.clone();
                    bl = true;
                } else {
                    PathIterator pathIterator = generalPath.getPathIterator(null);
                    float[] fArray = new float[6];
                    pathIterator.next();
                    while (!pathIterator.isDone()) {
                        switch (pathIterator.currentSegment(fArray)) {
                            case 4: {
                                morphShape.myPath.closePath();
                                break;
                            }
                            case 2: {
                                morphShape.myPath.quadTo(fArray[0], fArray[1], fArray[2], fArray[3]);
                                break;
                            }
                            case 1: {
                                morphShape.myPath.lineTo(fArray[0], fArray[1]);
                                break;
                            }
                            case 0: {
                                morphShape.myPath.moveTo(fArray[0], fArray[1]);
                            }
                        }
                        pathIterator.next();
                    }
                }
                rNode2 = rNode2.child;
            }
            morphShape.myPath.closePath();
            return morphShape;
        }
        return null;
    }
}

